<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class User_Settings_Model
{
    private $user_id;
    private $user_profile_meta_key = "ultimate_ai_user_profile_info";

    public function __construct(){
        // Get the current user ID
        $this->user_id = get_current_user_id();
    }

    // Method to get the user settings
    public function get_user_metadata(){
        return get_user_meta($this->user_id, $this->user_profile_meta_key, true);
    }

    // Method to update the user settings
    public function update_user_settings($user_settings){
        return update_user_meta($this->user_id, $this->user_profile_meta_key, $user_settings);
    }
}
